<?php
// davood.php - Telegram Order Bot (PHP 8.0) - Safe: never returns 500 to Telegram
http_response_code(200);

// ====== CONFIG ======
$BOT_TOKEN = '8583512454:AAHzXR1FiW4WfucOoDrwkeDYc2qF39sC4Sk';
$ADMIN_ID  = 'davoodalidoost'; // your numeric telegram user id

$DB_HOST = 'localhost';
$DB_NAME = 'robotnad_opera';
$DB_USER = 'robotnad_opera';
$DB_PASS = 'Dd09136964467';
// ====================

// ---- logs ----
ini_set('display_errors', '0');
ini_set('log_errors', '1');
ini_set('error_log', __DIR__ . '/davood_error.txt');
error_reporting(E_ALL);

function logx($s) {
  @file_put_contents(__DIR__ . '/davood_error.txt', date('Y-m-d H:i:s')." | ".$s."\n", FILE_APPEND);
}

function tg($method, $data) {
  global $BOT_TOKEN;
  $url = "https://api.telegram.org/bot{$BOT_TOKEN}/{$method}";
  $ch = curl_init($url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
  $res = curl_exec($ch);
  $err = curl_error($ch);
  curl_close($ch);
  if ($res === false) throw new Exception("cURL: ".$err);
  return $res ?: '';
}

function sendMessage($chat_id, $text, $reply_markup=null) {
  $data = ['chat_id'=>$chat_id,'text'=>$text,'parse_mode'=>'HTML'];
  if ($reply_markup) $data['reply_markup'] = json_encode($reply_markup, JSON_UNESCAPED_UNICODE);
  return tg('sendMessage', $data);
}

function sendPhoto($chat_id, $file_id, $caption=null, $reply_markup=null) {
  $data = ['chat_id'=>$chat_id,'photo'=>$file_id];
  if ($caption !== null) { $data['caption']=$caption; $data['parse_mode']='HTML'; }
  if ($reply_markup) $data['reply_markup'] = json_encode($reply_markup, JSON_UNESCAPED_UNICODE);
  return tg('sendPhoto', $data);
}

function answerCb($cbid, $text) {
  return tg('answerCallbackQuery', ['callback_query_id'=>$cbid,'text'=>$text]);
}

// DB (lazy connect)
function db() {
  static $pdo = null;
  global $DB_HOST,$DB_NAME,$DB_USER,$DB_PASS;
  if ($pdo) return $pdo;

  if (!class_exists('PDO')) throw new Exception("PDO missing");
  if (!in_array('mysql', PDO::getAvailableDrivers(), true)) throw new Exception("pdo_mysql not enabled");

  $dsn = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4";
  $pdo = new PDO($dsn, $DB_USER, $DB_PASS, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
  return $pdo;
}

function getState($user_id) {
  $pdo = db();
  $st = $pdo->prepare("SELECT user_id, step, temp_json FROM user_state WHERE user_id=?");
  $st->execute([$user_id]);
  $row = $st->fetch();
  if (!$row) {
    $pdo->prepare("INSERT INTO user_state(user_id, step, temp_json) VALUES(?, 'start', NULL)")->execute([$user_id]);
    return ['user_id'=>$user_id,'step'=>'start','temp_json'=>null];
  }
  return $row;
}

function setState($user_id, $step, $tempArr=null) {
  $pdo = db();
  $temp_json = ($tempArr===null) ? null : json_encode($tempArr, JSON_UNESCAPED_UNICODE);
  $pdo->prepare("UPDATE user_state SET step=?, temp_json=? WHERE user_id=?")->execute([$step, $temp_json, $user_id]);
}

function resetState($user_id) { setState($user_id, 'start', null); }

function getOrder($order_id) {
  $pdo = db();
  $st = $pdo->prepare("SELECT * FROM orders WHERE id=?");
  $st->execute([$order_id]);
  $o = $st->fetch();
  return $o ?: null;
}

// ================= MAIN =================
try {
  $raw = file_get_contents('php://input') ?: '';
  @file_put_contents(__DIR__ . '/davood_updates.txt', "----\n".date('Y-m-d H:i:s')."\n".$raw."\n", FILE_APPEND);

  $u = json_decode($raw, true);
  if (!is_array($u)) { echo "OK"; exit; }

  // ---------- Admin buttons ----------
  if (isset($u['callback_query'])) {
    $cb = $u['callback_query'];
    $cbid = (string)($cb['id'] ?? '');
    $from_id = (int)($cb['from']['id'] ?? 0);
    $data = (string)($cb['data'] ?? '');

    if ($from_id !== (int)$ADMIN_ID) {
      answerCb($cbid, "دسترسی ندارید");
      echo "OK"; exit;
    }

    if (preg_match('/^(avail|unavail|paylink):(\d+)$/', $data, $m)) {
      $action = $m[1];
      $order_id = (int)$m[2];
      $order = getOrder($order_id);

      if (!$order) { answerCb($cbid, "سفارش پیدا نشد"); echo "OK"; exit; }

      if ($action === 'avail') {
        db()->prepare("UPDATE orders SET status='available' WHERE id=?")->execute([$order_id]);
        sendMessage((int)$order['user_id'], "✅ محصول/رنگ انتخابی شما موجود است.\nمنتظر لینک پرداخت باشید.");
        answerCb($cbid, "ثبت شد: موجود");
      } elseif ($action === 'unavail') {
        db()->prepare("UPDATE orders SET status='unavailable' WHERE id=?")->execute([$order_id]);
        sendMessage((int)$order['user_id'], "❌ متأسفانه این محصول/رنگ فعلاً موجود نیست.");
        answerCb($cbid, "ثبت شد: ناموجود");
      } elseif ($action === 'paylink') {
        sendMessage((int)$ADMIN_ID, "برای ارسال لینک پرداخت این دستور رو بفرست:\n<code>/pay {$order_id} https://...</code>");
        answerCb($cbid, "راهنما ارسال شد");
      }
    } else {
      answerCb($cbid, "دستور نامعتبر");
    }

    echo "OK"; exit;
  }

  // ---------- Message ----------
  if (!isset($u['message'])) { echo "OK"; exit; }
  $msg = $u['message'];

  $chat_id = (int)($msg['chat']['id'] ?? 0);
  $user_id = (int)($msg['from']['id'] ?? 0);
  $username = $msg['from']['username'] ?? null;
  $full_name = trim(($msg['from']['first_name'] ?? '') . ' ' . ($msg['from']['last_name'] ?? ''));
  $text = $msg['text'] ?? null;

  // Admin pay: /pay ORDER_ID URL
  if ($text && preg_match('/^\/pay\s+(\d+)\s+(https?:\/\/\S+)/u', trim($text), $m)) {
    if ($user_id !== (int)$ADMIN_ID) { echo "OK"; exit; }
    $order_id = (int)$m[1];
    $url = $m[2];

    $order = getOrder($order_id);
    if (!$order) { sendMessage($chat_id, "سفارش پیدا نشد."); echo "OK"; exit; }

    db()->prepare("UPDATE orders SET status='payment_sent' WHERE id=?")->execute([$order_id]);
    sendMessage((int)$order['user_id'], "💳 لینک پرداخت سفارش شما:\n{$url}\nبعد از پرداخت رسید را ارسال کنید.");
    sendMessage($chat_id, "✅ ارسال شد.");
    echo "OK"; exit;
  }

  // Flow state
  $state = getState($user_id);
  $step = (string)$state['step'];
  $temp = $state['temp_json'] ? json_decode($state['temp_json'], true) : [];
  if (!is_array($temp)) $temp = [];

  if ($text === '/start') {
    resetState($user_id);
    sendMessage($chat_id, "سلام 👋\nروی <b>شروع سفارش</b> بزن.", [
      'keyboard' => [[['text'=>'شروع سفارش 🛒']]],
      'resize_keyboard' => true
    ]);
    echo "OK"; exit;
  }

  if ($text === 'شروع سفارش 🛒') {
    setState($user_id, 'waiting_photo', ['photos'=>[]]);
    sendMessage($chat_id, "عکس(های) محصول رو بفرست.\nوقتی تموم شد بنویس: <b>تمام</b>\nبرای لغو: <b>لغو</b>");
    echo "OK"; exit;
  }

  if ($text && trim($text) === 'لغو') {
    resetState($user_id);
    sendMessage($chat_id, "لغو شد. /start", ['remove_keyboard'=>true]);
    echo "OK"; exit;
  }

  // 1) photos
  if ($step === 'waiting_photo') {
    if (isset($msg['photo'])) {
      $best = end($msg['photo']);
      $photos = (isset($temp['photos']) && is_array($temp['photos'])) ? $temp['photos'] : [];
      $photos[] = $best['file_id'];
      setState($user_id, 'waiting_photo', ['photos'=>$photos]);
      sendMessage($chat_id, "✅ عکس دریافت شد. اگر تمام شد بنویس: <b>تمام</b>");
      echo "OK"; exit;
    }

    if ($text && trim($text) === 'تمام') {
      $photos = (isset($temp['photos']) && is_array($temp['photos'])) ? $temp['photos'] : [];
      if (count($photos) === 0) { sendMessage($chat_id, "حداقل یک عکس بفرست 🙂"); echo "OK"; exit; }

      setState($user_id, 'waiting_contact', ['photos'=>$photos]);
      sendMessage($chat_id, "شماره تماس رو با دکمه زیر ارسال کن:", [
        'keyboard' => [
          [['text'=>'ارسال شماره تماس ☎️', 'request_contact'=>true]],
          [['text'=>'لغو']]
        ],
        'resize_keyboard'=>true,
        'one_time_keyboard'=>true
      ]);
      echo "OK"; exit;
    }

    sendMessage($chat_id, "عکس بفرست یا بنویس <b>تمام</b>.");
    echo "OK"; exit;
  }

  // 2) contact
  if ($step === 'waiting_contact') {
    if (isset($msg['contact']['phone_number'])) {
      $phone = (string)$msg['contact']['phone_number'];
      $photos = (isset($temp['photos']) && is_array($temp['photos'])) ? $temp['photos'] : [];

      $pdo = db();
      $pdo->prepare("INSERT INTO orders(user_id, username, full_name, phone, photos_json, status)
                     VALUES(?,?,?,?,?, 'pending')")
          ->execute([$user_id, $username, $full_name, $phone, json_encode($photos, JSON_UNESCAPED_UNICODE)]);
      $order_id = (int)$pdo->lastInsertId();

      setState($user_id, 'waiting_qty', ['order_id'=>$order_id]);
      sendMessage($chat_id, "✅ ثبت شد. حالا تعداد رو بنویس (مثلاً 2)", ['remove_keyboard'=>true]);
      echo "OK"; exit;
    }

    sendMessage($chat_id, "شماره تماس رو فقط با دکمه ارسال کن.");
    echo "OK"; exit;
  }

  // 3) qty
  if ($step === 'waiting_qty') {
    $order_id = (int)($temp['order_id'] ?? 0);
    $qty = (int)trim((string)($text ?? ''));
    if ($order_id <= 0) { resetState($user_id); sendMessage($chat_id, "خطا. /start"); echo "OK"; exit; }
    if ($qty <= 0) { sendMessage($chat_id, "تعداد نامعتبره. مثل 1 یا 2"); echo "OK"; exit; }

    db()->prepare("UPDATE orders SET qty=? WHERE id=? AND user_id=?")->execute([$qty, $order_id, $user_id]);
    setState($user_id, 'waiting_color', ['order_id'=>$order_id]);
    sendMessage($chat_id, "حالا رنگ رو بنویس (مثلاً سفید/صورتی)");
    echo "OK"; exit;
  }

  // 4) color -> send to admin
  if ($step === 'waiting_color') {
    $order_id = (int)($temp['order_id'] ?? 0);
    $color = trim((string)($text ?? ''));
    if ($order_id <= 0) { resetState($user_id); sendMessage($chat_id, "خطا. /start"); echo "OK"; exit; }
    if ($color === '') { sendMessage($chat_id, "رنگ رو بنویس 🙂"); echo "OK"; exit; }

    db()->prepare("UPDATE orders SET color=? WHERE id=? AND user_id=?")->execute([$color, $order_id, $user_id]);
    $order = getOrder($order_id);
    if (!$order) { resetState($user_id); sendMessage($chat_id, "خطا. /start"); echo "OK"; exit; }

    $photos = json_decode($order['photos_json'] ?: '[]', true);
    if (!is_array($photos)) $photos = [];

    $caption =
      "🧾 <b>سفارش جدید</b>\n".
      "🆔 OrderID: <b>{$order['id']}</b>\n".
      "👤 نام: {$order['full_name']}\n".
      "🔗 یوزرنیم: @" . ($order['username'] ?: 'ندارد') . "\n".
      "☎️ تلفن: <b>{$order['phone']}</b>\n".
      "🔢 تعداد: <b>{$order['qty']}</b>\n".
      "🎨 رنگ: <b>{$order['color']}</b>\n".
      "👤 UserID: <code>{$order['user_id']}</code>";

    $buttons = [
      [
        ['text'=>'✅ موجوده', 'callback_data'=>"avail:{$order['id']}"],
        ['text'=>'❌ ناموجود', 'callback_data'=>"unavail:{$order['id']}"],
      ],
      [
        ['text'=>'💳 درخواست لینک پرداخت', 'callback_data'=>"paylink:{$order['id']}"],
      ],
    ];

    if (count($photos) > 0) {
      sendPhoto((int)$ADMIN_ID, $photos[0], $caption, ['inline_keyboard'=>$buttons]);
      for ($i=1; $i<count($photos); $i++) sendPhoto((int)$ADMIN_ID, $photos[$i]);
    } else {
      sendMessage((int)$ADMIN_ID, $caption, ['inline_keyboard'=>$buttons]);
    }

    setState($user_id, 'done', null);
    sendMessage($chat_id, "✅ سفارش ثبت شد. منتظر تایید موجودی باش.");
    echo "OK"; exit;
  }

  sendMessage($chat_id, "برای شروع /start");
  echo "OK"; exit;

} catch (Throwable $e) {
  // Never let Telegram see 500
  logx("FATAL: ".$e->getMessage());
  echo "OK";
  exit;
}
