<?php
// bot.php - Telegram Flower Shop Bot (Core)
http_response_code(200);

// ====== CONFIG ======
$BOT_TOKEN = '8583512454:AAHzXR1FiW4WfucOoDrwkeDYc2qF39sC4Sk'; // توکن جدیدت را اینجا بگذار
$ADMIN_CHAT_ID = '8043322177'; // شناسه عددی تلگرام خودت (از @userinfobot بگیر)

$DB_HOST = 'localhost';
$DB_NAME = 'robotnad_opera'; // نام دیتابیسی که ایجاد کردی
$DB_USER = 'robotnad_opera';
$DB_PASS = 'Dd09136964467';
// ====================

// ---- تنظیمات خطا ----
ini_set('display_errors', '0');
ini_set('log_errors', '1');
ini_set('error_log', __DIR__ . '/bot_errors.log');
error_reporting(E_ALL);

// ---- تابع ثبت لاگ ----
function logEvent($message) {
    $logFile = __DIR__ . '/bot_events.log';
    $time = date('Y-m-d H:i:s');
    @file_put_contents($logFile, "[$time] $message\n", FILE_APPEND);
}

// ---- تابع ارتباط با تلگرام ----
function sendTelegram($method, $data) {
    global $BOT_TOKEN;
    $url = "https://api.telegram.org/bot{$BOT_TOKEN}/{$method}";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // اگر مشکل SSL داری
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    $result = curl_exec($ch);
    if(curl_error($ch)) {
        logEvent('cURL Error: ' . curl_error($ch));
    }
    curl_close($ch);
    return $result;
}

// ---- تابع ارسال پیام ----
function sendMessage($chatId, $text, $replyMarkup = null) {
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($replyMarkup) {
        $data['reply_markup'] = json_encode($replyMarkup);
    }
    return sendTelegram('sendMessage', $data);
}

// ---- تابع ارسال پیام به ادمین ----
function notifyAdmin($text) {
    global $ADMIN_CHAT_ID;
    if (!empty($ADMIN_CHAT_ID)) {
        sendMessage($ADMIN_CHAT_ID, $text);
    }
}

// ---- اتصال به پایگاه داده ----
function getDatabase() {
    static $pdo = null;
    global $DB_HOST, $DB_NAME, $DB_USER, $DB_PASS;
    
    if ($pdo === null) {
        try {
            $dsn = "mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4";
            $pdo = new PDO($dsn, $DB_USER, $DB_PASS);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            logEvent('Database Connection Failed: ' . $e->getMessage());
            die('Database error.');
        }
    }
    return $pdo;
}

// ---- ذخیره کاربر جدید ----
function saveUser($telegramId, $username, $firstName, $lastName) {
    $db = getDatabase();
    // بررسی وجود کاربر
    $stmt = $db->prepare("SELECT id FROM users WHERE telegram_id = ?");
    $stmt->execute([$telegramId]);
    if ($stmt->fetch()) {
        return; // کاربر از قبل وجود دارد
    }
    // درج کاربر جدید
    $stmt = $db->prepare("INSERT INTO users (telegram_id, username, first_name, last_name) VALUES (?, ?, ?, ?)");
    $stmt->execute([$telegramId, $username, $firstName, $lastName]);
    logEvent("New user saved: $telegramId ($username)");
}

// ---- پردازش اصلی ----
try {
    $input = file_get_contents('php://input');
    $update = json_decode($input, true);
    
    // ذخیره لاگ برای دیباگ
    logEvent("Update received: " . substr($input, 0, 500));
    
    if (empty($update)) {
        echo 'OK';
        exit;
    }
    
    // پردازش پیام
    if (isset($update['message'])) {
        $message = $update['message'];
        $chatId = $message['chat']['id'];
        $userId = $message['from']['id'];
        $username = $message['from']['username'] ?? '';
        $firstName = $message['from']['first_name'] ?? '';
        $lastName = $message['from']['last_name'] ?? '';
        $text = $message['text'] ?? '';
        
        // ذخیره اطلاعات کاربر
        saveUser($userId, $username, $firstName, $lastName);
        
        // دستور /start
        if ($text === '/start') {
            $welcomeText = "🌸 به فروشگاه گل مصنوعی خوش آمدید!\n\n";
            $welcomeText .= "برای ثبت سفارش جدید، لطفاً از منوی زیر اقدام کنید:\n";
            $welcomeText .= "یا دستور /neworder را ارسال کنید.";
            
            $keyboard = [
                'keyboard' => [
                    [['text' => '📦 ثبت سفارش جدید']],
                    [['text' => '📋 سفارشات من'], ['text' => 'ℹ️ راهنما']]
                ],
                'resize_keyboard' => true,
                'one_time_keyboard' => false
            ];
            
            sendMessage($chatId, $welcomeText, $keyboard);
            notifyAdmin("👤 کاربر جدید: $firstName $lastName (@$username)");
        }
        // ثبت سفارش جدید
        elseif ($text === '📦 ثبت سفارش جدید' || $text === '/neworder') {
            $response = "✅ برای ثبت سفارش، لطفاً:\n\n";
            $response .= "1. عکس محصول مورد نظر را ارسال کنید\n";
            $response .= "2. سپس رنگ و تعداد مورد نیاز را به ترتیب ذکر کنید\n\n";
            $response .= "مثال: <code>صورتی، 2 عدد</code>\n\n";
            $response .= "یا برای راهنمایی بیشتر /help را بفرستید.";
            
            sendMessage($chatId, $response);
        }
        // هر پیام متنی دیگر
        elseif (!empty($text)) {
            sendMessage($chatId, "پیام شما دریافت شد: <b>$text</b>\n\nبرای شروع مجدد /start را بفرستید.");
        }
        // اگر کاربر عکس فرستاد
        elseif (isset($message['photo'])) {
            $photo = end($message['photo']); // گرفتن با کیفیت ترین عکس
            $photoId = $photo['file_id'];
            
            sendMessage($chatId, "✅ عکس محصول دریافت شد.\n\nلطفاً رنگ و تعداد مورد نظر خود را بنویسید.\nمثال: <code>قرمز، 3 عدد</code>");
            notifyAdmin("📸 کاربر $firstName عکس جدید ارسال کرد. (File ID: $photoId)");
        }
    }
    
    echo 'OK';
    
} catch (Exception $e) {
    logEvent('Critical Error: ' . $e->getMessage());
    echo 'OK'; // همیشه OK برگردان تا تلگرام پیغام خطا نبیند
}